const PlaylistItemType = Object.freeze({
	kTypeVideoFile: 0,
	kTypeAudioFile: 1,
	kTypeImageFile: 2,
	kTypeComment: 3,
	kTypeLive: 4,
	kTypeStream: 5
})

function PlaylistItem(object, playlistDocument) {
	this.unique_id = object.unique_id;
	this.actions = [];
	this.clip_type = undefined;
	this.last_modification_date = undefined;
	this.has_in_point = false;
	this.has_out_point = false;
	this.has_previous_item_mix_point = false;
	this.has_next_item_mix_point = false;
	this.is_offline = false;
	this.is_valid = false;
	this.name = "";
	this.is_disabled = false;
	this.proxy_url = "";
	this.thumbnail_url = "";
	this.url = undefined;
	this.displayed_start_timecode = undefined;
	this.media_file_duration = 0.0;
	this.duration_timecode = undefined;
	this.duration = 0.0;
	this.is_streamed = undefined;
	this.media_browser_item_unique_id = "";
	this.template_unique_id = "";
	this.remote_item_url = undefined;
	this.start_transition_duration = 0;
	this.start_transition_name = "";
	this.playback_mode = "None";
	this.in_point = undefined;
	this.out_point = undefined;
	this.thumbnail_data = undefined;
	this.frames_per_second = undefined;
	this.drop_frame = false;

	this.playlist_document = playlistDocument;

	this.updateFrom = function(object) {
		if (object) {
			if (object.duration != undefined)
				this.duration = object.duration;
			if (object.duration_timecode != undefined)
				this.duration_timecode = object.duration_timecode;
			if (object.clip_type != undefined)
				this.clip_type = object.clip_type;
			if (object.last_modification_date != undefined)
				this.last_modification_date = object.last_modification_date;
			if (object.is_offline != undefined)
				this.is_offline = object.is_offline;
			if (object.is_valid != undefined)
				this.is_valid = object.is_valid;
			if (object.name != undefined)
				this.name = object.name;
			if (object.is_disabled != undefined)
				this.is_disabled = object.is_disabled;
			if (object.url != undefined)
				this.url = object.url;
			if (object.displayed_start_timecode != undefined)
				this.displayed_start_timecode = object.displayed_start_timecode;
			if (object.is_streamed != undefined)
				this.is_streamed = object.is_streamed;
			if (object.has_in_point != undefined)
				this.has_in_point = object.has_in_point;
			if (object.has_out_point != undefined)
				this.has_out_point = object.has_out_point;
			if (object.has_previous_item_mix_point != undefined)
				this.has_previous_item_mix_point = object.has_previous_item_mix_point;
			if (object.has_next_item_mix_point != undefined)
				this.has_next_item_mix_point = object.has_next_item_mix_point;
			if (object.media_browser_item_unique_id != undefined)
				this.media_browser_item_unique_id = object.media_browser_item_unique_id;
			if (object.template_unique_id != undefined)
				this.template_unique_id = object.template_unique_id;
			if (object.remote_item_url != undefined)
				this.remote_item_url = object.remote_item_url;
			if (object.start_transition_duration != undefined)
				this.start_transition_duration = object.start_transition_duration;
			if (object.start_transition_name != undefined)
				this.start_transition_name = object.start_transition_name;
			if (object.video_codec != undefined)
				this.video_codec = object.video_codec;
			if (object.audio_codec != undefined)
				this.audio_codec = object.audio_codec;
			if (this.media_display_size != undefined)
				this.media_display_size = object.media_display_size;
			if (object.frames_per_second != undefined)
				this.frames_per_second = object.frames_per_second;
			if (object.drop_frame != undefined)
				this.drop_frame = object.drop_frame;
			if (object.playback_mode != undefined)
				this.playback_mode = object.playback_mode;
			if (object.in_point != undefined)
				this.in_point = object.in_point;
			if (object.out_point != undefined)
				this.out_point = object.out_point;
			if (object.proxy_url != undefined)
				this.proxy_url = object.proxy_url;
			if (object.thumbnail_url != undefined)
				this.thumbnail_url = object.thumbnail_url;
			if (object.thumbnail_data != undefined)
				this.thumbnail_data = object.thumbnail_data;
			if (object.media_file_duration != undefined)
				this.media_file_duration = object.media_file_duration;
			if (object.playlist_document != undefined)
				this.playlist_document = object.playlist_document;
			
			switch (this.clip_type) {
				case 4:
				case 5:
					this.video_codec = "N/A";
					this.audio_codec = "N/A";
					break;
				default:
					break;
			}
			

			if (object.actions != undefined) {
				//empty action list
				this.actions = [];

				for (let i = 0; i < object.actions.length; i++) {
					const raction = object.actions[i];
					const action = new PlaylistItemAction(raction, this);
					this.actions.push(action);
				}
			}

			// if (this.playlist_document) {
			// 	this.playlist_document.updateStartTimes();
			// }
		}
	}

	if (object) {
		this.updateFrom(object);
	}

	this.isValid = function() {
		return this.is_valid;
	}

	this.isComment = function() {
		return this.clip_type == PlaylistItemType.kTypeComment || this.is_comment;
	}

	this.isLive = function() {
		return this.clip_type == PlaylistItemType.kTypeLive;
	}

	this.isStream = function() {
		return this.clip_type == PlaylistItemType.kTypeStream;
	}

	this.isLiveOrStream = function() {
		return this.isLive() || this.isStream();
	}

	this.isEditable = function() {
		if (this.media_browser_item_unique_id != undefined && this.media_browser_item_unique_id != "") {
			return false;
		}
		if (this.remote_item_url != undefined && this.remote_item_url != "") {
			return false;
		}
		return true;
	}

	this.hasStartTransition = function() {
		return this.start_transition_name !== "";
	}

	this.playlistItemActionWithUniqueID = function(uniqueID) {
		for (let i = 0; i < this.actions.length; i++) {
			const action = this.actions[i];
			if (action.unique_id === uniqueID) {
				return action;
			}
		}

		return undefined;
	}


	this.getStatusClass = function() {

	}

	//should be a controller method
	this.getActionToolBarContentHTML = function() {
		let result = "";

		if (this.isEditable()) {
			result = "<span class='btn add_action_row_cta'>+</span>&nbsp;<span class='btn remove_action_row_cta'>-</span>";
		} else {
			result = "<div class='icon-template' title='Modifications is not allowed for an item that is coming either from Media Browser or from a XPLI,'><svg width='15px' height='15px' viewBox='0 0 78 78' version='1.1'  style='fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;'><path id='Regular-M' d='M70.908,15.419l4.932,-4.833c2.49,-2.491 2.588,-5.127 0.39,-7.422l-1.66,-1.612c-2.246,-2.246 -4.931,-2.002 -7.373,0.391l-4.98,4.883l8.691,8.593Zm-0.293,54.151c1.465,1.465 3.906,1.465 5.322,0c1.416,-1.514 1.465,-3.858 0,-5.322l-61.377,-61.377c-1.464,-1.465 -3.955,-1.514 -5.371,0c-1.464,1.416 -1.464,3.906 0,5.322l61.426,61.377Zm-17.529,-36.426l13.525,-13.525l-8.545,-8.594l-13.574,13.574l8.594,8.545Zm-39.746,39.697l26.22,-26.22l-8.544,-8.594l-26.27,26.269l-4.639,10.84c-0.488,1.172 0.782,2.539 1.953,2.051l11.28,-4.346Z' style='fill-rule:nonzero;'/></svg></div>";
		}

		return result;
	}

	this.getTypeString = function() {
		let result = "";

		switch(this.clip_type) {
			case PlaylistItemType.kTypeVideoFile:
			case PlaylistItemType.kTypeAudioFile:
			case PlaylistItemType.kTypeImageFile:
				result = "Media";
				break;
			case PlaylistItemType.kTypeComment:
				result = "Comment"
				break;
			case PlaylistItemType.kTypeLive:
				result = "Live"
				break;
			case PlaylistItemType.kTypeStream:
				result = "Stream";
				break;
		}

		if (this.remote_item_url != undefined && this.remote_item_url != "") {
			result += " (XPLI)";
		}

		if (this.media_browser_item_unique_id != undefined && this.media_browser_item_unique_id != "") {
			result += " (MEDIA BROWSER)"
		}

		return result;
	}

	//should be a controller method (bindings shortcut for now)
	this.getStatusIconHTML = function() {
		let result = "";
		if (!this.is_offline) {
			result = "<span class='valid'>&#10004;</span>";
			//live or stream will not have the offline status
			if (this.isLiveOrStream()) {
				if (!this.is_valid) {
					result = "<span class='invalid'>&#10006;</span>";
				}
			}
		} else {
			result = "<span class='invalid'>&#10006;</span";
		}

		return result;
	}

	this.getResolvedLastModificationDate = function() {
		let result = ""
		if (this.last_modification_date == undefined) {
			result = "Unknown";
		} else if (this.clip_type == PlaylistItemType.kTypeLive  || (this.clip_type == PlaylistItemType.kTypeStream && this.is_streamed)) {
			result = "N/A";
		} else {
			//show correct time following local timezone
			let date = new Date(this.last_modification_date);
			// const offsetMs = date.getTimezoneOffset() * 60 * 1000;
			// const dateLocal = new Date(date.getTime() - offsetMs);
			//result = dateLocal.toISOString().slice(0, 19).replace(/-/g, "/").replace("T", " ");
			
			// result = date.toUTCString();
			result = date.toLocaleString();
		}

		return result;
	}
	
	this.getResolvedDisplayURL = function() {

		function shortenURL(url) {
			if (url == "" || url == undefined) {
				return "Unknown";
			}
			let splittedPath = url.split("/");
			let shortPath = splittedPath[splittedPath.length-2]+"/"+splittedPath[splittedPath.length-1];

			if (shortPath.length > 22) {
				shortPath = "..." + shortPath.substring(shortPath.length-22, shortPath.length);
			} else {
				shortPath = url;
			}

			return shortPath;
		}

		let result = ""

		if (this.isLiveOrStream()) {
			result = "N/A";

			if (this.isStream()) {
				result = shortenURL(this.url);
			} else {
				result = this.live_source_name;
			}
		} else {
			result = shortenURL(this.url);
		}

		return result;
	}

	this.getDuration = function() {
	    let result = this.media_file_duration;

	    if (this.has_out_point) {
	      result = this.out_point;
	    }

	    if (this.has_in_point) {
	      result -= this.in_point;
	    }

	    return result;
	}
	
	this.getFormat = function () {
		let format = "";
		if (this.media_display_size !== undefined) {
			if (this.media_display_size.width != 0 && this.media_display_size.height != 0) {
				format = this.media_display_size.width + "x" + this.media_display_size.height;
			}
		}

		if (this.frames_per_second !== undefined) {
			if (format != "") {
				format += " - ";
			}
			format += Math.round(this.frames_per_second*100)/100 + " fps";
		}
		
		return format;
	}
}
